/**
 * 管理员后台商店信息字段脚本
 */

(function($) {
	'use strict';

	$(document).ready(function() {
		// 只在用户编辑页面执行
		if (!$('#tooto-store-information-fields').length) {
			return;
		}

		var fileFrame;
		var $profilePictureInput = $('#tooto_profile_picture');
		var $profilePicturePreview = $('.tooto-admin-profile-picture-preview');
		var $removeButton = $('.tooto-remove-profile-picture');

		// 上传头像按钮
		$('.tooto-upload-profile-picture').on('click', function(e) {
			e.preventDefault();

			// 如果已经存在媒体框架，先打开它
			if (fileFrame) {
				fileFrame.open();
				return;
			}

			// 创建媒体框架
			fileFrame = wp.media({
				title: 'Select Profile Picture',
				button: {
					text: 'Use this picture'
				},
				multiple: false,
				library: {
					type: 'image'
				}
			});

			// 当选择图片时
			fileFrame.on('select', function() {
				var attachment = fileFrame.state().get('selection').first().toJSON();
				
				// 更新预览图片
				$profilePicturePreview.attr('src', attachment.url);
				
				// 更新隐藏字段
				$profilePictureInput.val(attachment.id);
				
				// 显示删除按钮
				$removeButton.show();
			});

			// 打开媒体框架
			fileFrame.open();
		});

		// 删除头像按钮
		$removeButton.on('click', function(e) {
			e.preventDefault();
			
			// 重置为默认头像
			var defaultAvatar = $profilePicturePreview.data('default-avatar') || $profilePicturePreview.attr('src');
			$profilePicturePreview.attr('src', defaultAvatar);
			
			// 清空隐藏字段
			$profilePictureInput.val('');
			
			// 隐藏删除按钮
			$(this).hide();
		});
	});

})(jQuery);

