/**
 * Blocksy 账户弹窗自定义脚本
 */

(function($) {
	'use strict';

	// 初始化自定义下拉选择器
	function initCustomSelects() {
		$('#account-modal .tooto-custom-select').each(function() {
			var $select = $(this);
			
			// 如果已经初始化过，跳过
			if ($select.data('tooto-initialized')) {
				return;
			}
			
			$select.data('tooto-initialized', true);
			
			var $trigger = $select.find('.tooto-custom-select-trigger');
			var $hiddenSelect = $('#' + $select.data('target'));
			var $valueDisplay = $select.find('.tooto-custom-select-value');

			// 点击触发器打开/关闭下拉
			$trigger.off('click.tooto').on('click.tooto', function(e) {
				e.stopPropagation();
				var isOpen = $select.hasClass('open');
				
				// 关闭所有其他下拉
				$('#account-modal .tooto-custom-select').removeClass('open');
				
				// 切换当前下拉
				if (!isOpen) {
					$select.addClass('open');
				}
			});

			// 点击选项
			$select.find('.tooto-custom-select-option').off('click.tooto').on('click.tooto', function(e) {
				e.stopPropagation();
				var $option = $(this);
				var value = $option.data('value');
				var text = $option.text();

				// 更新显示值
				$valueDisplay.text(text);

				// 更新选中状态
				$select.find('.tooto-custom-select-option').removeClass('selected');
				$option.addClass('selected');

				// 更新隐藏的 select
				$hiddenSelect.val(value).trigger('change');

				// 关闭下拉
				$select.removeClass('open');

				// 添加视觉反馈
				$trigger.addClass('changed');
				setTimeout(function() {
					$trigger.removeClass('changed');
				}, 300);
			});

			// 键盘支持
			$trigger.off('keydown.tooto').on('keydown.tooto', function(e) {
				if (e.key === 'Enter' || e.key === ' ') {
					e.preventDefault();
					$trigger.click();
				}
			});

			$select.find('.tooto-custom-select-option').off('keydown.tooto').on('keydown.tooto', function(e) {
				if (e.key === 'Enter' || e.key === ' ') {
					e.preventDefault();
					$(this).click();
				}
			});
		});
	}

	// 初始化文件上传功能
	function initFileUploads() {
		// 文件上传按钮功能（使用事件委托）
		$(document).off('click.tooto', '#account-modal .tooto-upload-button').on('click.tooto', '#account-modal .tooto-upload-button', function(e) {
			e.preventDefault();
			var targetId = $(this).data('target');
			$('#' + targetId).click();
		});

		// 文件选择后显示文件名（使用事件委托）
		$(document).off('change.tooto', '#account-modal .tooto-file-input').on('change.tooto', '#account-modal .tooto-file-input', function(e) {
			var file = e.target.files[0];
			var $wrapper = $(this).closest('.tooto-file-upload-wrapper');
			var $fileName = $wrapper.find('.tooto-file-name[data-target="' + $(this).attr('id') + '"]');
			
			if (file) {
				$fileName.text(file.name).show();
			} else {
				$fileName.text('').hide();
			}
		});
	}

	// 初始化输入框聚焦效果
	function initInputFocus() {
		$(document).off('focus.tooto blur.tooto', '#account-modal form .input').on('focus.tooto', '#account-modal form .input', function() {
			$(this).addClass('focused');
		}).on('blur.tooto', '#account-modal form .input', function() {
			$(this).removeClass('focused');
		});
	}

	// 点击外部关闭下拉（全局事件）
	$(document).on('click.tooto', function(e) {
		if (!$(e.target).closest('.tooto-custom-select').length) {
			$('#account-modal .tooto-custom-select').removeClass('open');
		}
	});

	// 初始化所有功能
	function initAll() {
		initCustomSelects();
		initFileUploads();
		initInputFocus();
	}

	// 页面加载完成后初始化
	$(document).ready(function() {
		initAll();
	});

	// 监听 Blocksy 弹窗打开事件
	if (typeof ctEvents !== 'undefined') {
		ctEvents.on('ct:modal:opened', function(modalContainer) {
			if (modalContainer && modalContainer.id === 'account-modal') {
				// 延迟一点确保 DOM 完全加载
				setTimeout(function() {
					initAll();
				}, 100);
			}
		});
	}

	// 监听账户弹窗的特定事件
	if (typeof ctEvents !== 'undefined') {
		ctEvents.on('blocksy:account:register:start', function() {
			setTimeout(function() {
				initAll();
			}, 100);
		});
	}

	// 使用 MutationObserver 监听弹窗内容变化（备用方案）
	if (typeof MutationObserver !== 'undefined') {
		var observer = new MutationObserver(function(mutations) {
			var hasAccountModal = $('#account-modal').length > 0;
			if (hasAccountModal && $('#account-modal .tooto-custom-select').length > 0) {
				initAll();
			}
		});

		$(document).ready(function() {
			observer.observe(document.body, {
				childList: true,
				subtree: true
			});
		});
	}

	// 错误弹窗功能
	var ErrorDialog = {
		_originalDataPanel: null,
		_tempStyleSheet: null,
		_protectionHandler: null,
		
		show: function(message) {
			var $dialog = $('#tooto-error-dialog');
			var $message = $dialog.find('.tooto-error-dialog-message');
			
			// 设置错误消息
			$message.html(message);
			
			// 保护 Blocksy account-modal（防止被关闭）
			this.protectBlocksyAccountModal();
			
			// 显示弹窗
			$dialog.fadeIn(200);
			$('body').addClass('tooto-error-dialog-open');
		},
		
		hide: function() {
			var $dialog = $('#tooto-error-dialog');
			var self = this;
			
			// 先隐藏弹窗
			$dialog.fadeOut(200);
			$('body').removeClass('tooto-error-dialog-open');
			
			// 延迟恢复 Blocksy account-modal 保护（等待动画完成，防止 Blocksy 立即关闭）
			// 参考代码使用 300ms 延迟
			setTimeout(function() {
				self.unprotectBlocksyAccountModal();
			}, 300);
		},
		
		protectBlocksyAccountModal: function() {
			var $body = $('body');
			var dataPanel = $body.attr('data-panel');
			
			// 如果 account-modal 是打开的（有 data-panel 属性）
			if (dataPanel) {
				// 保存原始值
				this._originalDataPanel = dataPanel;
				
				// 移除 data-panel 属性（这样 Blocksy 就不会关闭 modal）
				$body.removeAttr('data-panel');
				
				// 添加备份属性（用于样式）
				$body.attr('data-tooto-panel-backup', dataPanel);
				
				// 创建临时样式表，保持 panel 显示
				if (!this._tempStyleSheet) {
					this._tempStyleSheet = $('<style id="tooto-panel-backup-styles"></style>');
					$('head').append(this._tempStyleSheet);
				}
				
				// 添加样式规则，确保 panel 保持显示并禁用动画
				var styles = '\n' +
					'body[data-tooto-panel-backup] .ct-panel.active {\n' +
					'    display: flex !important;\n' +
					'    opacity: 1 !important;\n' +
					'    pointer-events: auto !important;\n' +
					'}\n' +
					'body[data-tooto-panel-backup*="in"] .ct-panel.active {\n' +
					'    opacity: 1 !important;\n' +
					'    pointer-events: auto !important;\n' +
					'}\n' +
					'/* 禁用 move-in 动画，防止恢复 data-panel 时重新触发 */\n' +
					'body[data-tooto-panel-backup*="in"] [data-behaviour="modal"].active .ct-panel-content {\n' +
					'    animation: none !important;\n' +
					'    animation-name: none !important;\n' +
					'}\n' +
					'/* 禁用 shake 动画，防止错误状态时重新触发 */\n' +
					'body[data-tooto-panel-backup] .ct-account-modal.ct-error {\n' +
					'    animation: none !important;\n' +
					'}\n';
				this._tempStyleSheet.html(styles);
				
				// 在捕获阶段拦截点击事件
				this._blockClickEvents();
			}
		},
		
		_blockClickEvents: function() {
			var self = this;
			
			// 如果已经有处理器，先移除
			if (this._protectionHandler) {
				document.removeEventListener('click', this._protectionHandler, true);
			}
			
			// 创建新的处理器
			this._protectionHandler = function(e) {
				var $target = $(e.target);
				var isInErrorDialog = $target.closest('#tooto-error-dialog').length;
				var isCloseButton = isInErrorDialog && (
					$target.closest('.tooto-error-dialog-close, .tooto-error-dialog-button').length ||
					$target.hasClass('tooto-error-dialog-overlay')
				);
				
				// 如果点击在错误弹窗内，阻止事件传播（防止触发 Blocksy 的关闭逻辑）
				if (isInErrorDialog) {
					// 如果是关闭按钮，先处理关闭逻辑
					if (isCloseButton) {
						e.preventDefault();
						e.stopPropagation();
						e.stopImmediatePropagation();
						
						// 延迟执行 hide，确保事件完全被阻止
						setTimeout(function() {
							self.hide();
						}, 0);
						
						return false;
					}
					
					// 其他错误弹窗内的点击，只阻止传播，不处理
					e.stopPropagation();
					e.stopImmediatePropagation();
					return false;
				}
				
				// 如果点击在 account-modal 或 ct-panel 内，允许事件继续
				if ($target.closest('#account-modal, .ct-panel').length) {
					return true;
				}
				
				// 其他所有点击都阻止传播（防止 Blocksy 关闭 modal）
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			};
			
			// 在捕获阶段添加监听器（优先级最高）
			document.addEventListener('click', this._protectionHandler, true);
		},
		
		unprotectBlocksyAccountModal: function() {
			var $body = $('body');
			var self = this;
			
			// 移除点击事件拦截
			if (this._protectionHandler) {
				document.removeEventListener('click', this._protectionHandler, true);
				this._protectionHandler = null;
			}
			
			// 先移除可能导致动画的类（如 ct-error）
			var $accountModal = $('#account-modal');
			if ($accountModal.length) {
				$accountModal.removeClass('ct-error');
			}
			
			// 恢复 data-panel 属性（在移除样式表之前，这样动画禁用规则仍然生效）
			if (this._originalDataPanel) {
				var originalValue = this._originalDataPanel;
				this._originalDataPanel = null;
				
				// 先恢复属性，但保持样式表来禁用动画
				$body.attr('data-panel', originalValue);
				
				// 延迟移除样式表和备份属性，确保动画不会重新触发
				// 使用双 requestAnimationFrame 确保在下一帧之后执行
				requestAnimationFrame(function() {
					requestAnimationFrame(function() {
						// 移除临时样式表
						if (self._tempStyleSheet) {
							self._tempStyleSheet.remove();
							self._tempStyleSheet = null;
						}
						
						// 移除备份属性
						$body.removeAttr('data-tooto-panel-backup');
					});
				});
			} else {
				// 如果没有原始值，直接移除样式表和备份属性
				if (this._tempStyleSheet) {
					this._tempStyleSheet.remove();
					this._tempStyleSheet = null;
				}
				$body.removeAttr('data-tooto-panel-backup');
			}
		}
	};

	// 关闭事件已经在 _protectionHandler 中处理，这里不需要额外的监听器

	// ESC 键关闭弹窗
	$(document).on('keydown.tooto', function(e) {
		if (e.key === 'Escape' && $('#tooto-error-dialog').is(':visible')) {
			ErrorDialog.hide();
		}
	});

	// 拦截 Blocksy 的错误显示，改为显示二级弹窗
	// 方法1: 监听 Blocksy 的注册错误事件（立即处理）
	if (typeof ctEvents !== 'undefined') {
		ctEvents.on('blocksy:account:register:error', function() {
			// 使用 requestAnimationFrame 确保在下一帧立即处理
			requestAnimationFrame(function() {
				var $errorContainer = $('#account-modal .ct-form-notification-error');
				if ($errorContainer.length) {
					var errorMessage = $errorContainer.html();
					if (errorMessage) {
						// 立即隐藏 Blocksy 的错误显示
						$errorContainer.css('display', 'none');
						$errorContainer.remove();
						$('#account-modal .ct-account-modal').removeClass('ct-error');
						
						// 立即显示我们的错误弹窗
						ErrorDialog.show(errorMessage);
					}
				}
			});
		});
	}

	// 使用 MutationObserver 监听错误插入（更可靠的方法，立即拦截）
	if (typeof MutationObserver !== 'undefined') {
		var errorObserver = new MutationObserver(function(mutations) {
			mutations.forEach(function(mutation) {
				if (mutation.addedNodes.length) {
					Array.prototype.forEach.call(mutation.addedNodes, function(node) {
						if (node.nodeType === 1) { // Element node
							var $node = $(node);
							var $errorContainer = null;
							
							// 检查是否是错误容器本身
							if ($node.hasClass('ct-form-notification-error')) {
								$errorContainer = $node;
							} 
							// 检查是否包含错误容器
							else if ($node.find && $node.find('.ct-form-notification-error').length) {
								$errorContainer = $node.find('.ct-form-notification-error').first();
							}
							// 检查子节点中是否有错误容器（使用原生 DOM 方法，更快）
							else if (node.querySelector) {
								var errorEl = node.querySelector('.ct-form-notification-error');
								if (errorEl) {
									$errorContainer = $(errorEl);
								}
							}
							
							if ($errorContainer && $errorContainer.length && $errorContainer.closest('#account-modal').length) {
								// 立即移除错误，不要延迟
								var errorMessage = $errorContainer.html();
								if (errorMessage && $('#tooto-error-dialog').is(':hidden')) {
									// 立即隐藏 Blocksy 的错误显示（在渲染之前）
									$errorContainer.css('display', 'none');
									$errorContainer.remove();
									$('#account-modal .ct-account-modal').removeClass('ct-error');
									
									// 立即显示我们的错误弹窗
									ErrorDialog.show(errorMessage);
								}
							}
						}
					});
				}
			});
		});

		$(document).ready(function() {
			// 监听整个文档，包括 account-modal
			errorObserver.observe(document.body, {
				childList: true,
				subtree: true,
				attributes: false
			});
		});
	}

	// 拦截 insertAdjacentHTML 方法，在错误插入之前拦截
	var originalInsertAdjacentHTML = Element.prototype.insertAdjacentHTML;
	Element.prototype.insertAdjacentHTML = function(position, html) {
		// 检查是否是插入错误信息
		if (html && html.includes('ct-form-notification-error')) {
			var $this = $(this);
			// 如果是注册表单容器
			if ($this.closest('#account-modal').length && $this.closest('.ct-register-form').length) {
				// 提取错误信息
				var tempDiv = document.createElement('div');
				tempDiv.innerHTML = html;
				var errorElement = tempDiv.querySelector('.ct-form-notification-error');
				if (errorElement) {
					var errorMessage = errorElement.innerHTML;
					// 不插入错误，直接显示我们的弹窗
					setTimeout(function() {
						ErrorDialog.show(errorMessage);
					}, 0);
					return; // 阻止插入
				}
			}
		}
		// 其他情况正常插入
		return originalInsertAdjacentHTML.call(this, position, html);
	};

	// 暴露到全局，方便其他地方调用
	window.tootoErrorDialog = ErrorDialog;

})(jQuery);

