jQuery(document).ready(function($) {
    // 检查是否有参数
    if (typeof tooto_checkout_params === 'undefined') {
        return;
    }

    // 1. 始终执行：强制锁定并选中 "Ship to a different address" checkbox
    // 这是为了配合 CSS 隐藏 Billing Fields 的逻辑，必须强制展开 Shipping Fields
    function forceShipToDifferent() {
        var $shipToDifferent = $('#ship-to-different-address-checkbox');
        if ($shipToDifferent.length) {
            // 确保选中
            if (!$shipToDifferent.is(':checked')) {
                 $shipToDifferent.prop('checked', true).trigger('change');
            }
            
            // 移除所有事件处理器并阻止点击
            $shipToDifferent.off('click').on('click', function(e) {
                e.preventDefault();
                return false;
            });
            // 锁定容器
            $shipToDifferent.closest('h3').css({
                'pointer-events': 'none',
                'opacity': '0.8',
                'cursor': 'not-allowed'
            });
        }
    }

    // 2. 条件执行：锁定配送地址字段函数
    // 只有在 tooto_checkout_params.is_address_locked 为 true 时才执行
    function lockShippingFields() {
        if (!tooto_checkout_params.is_address_locked) {
            return;
        }

        // 1. 处理所有输入框 - 设置 readonly
        var $inputs = $('.woocommerce-checkout .woocommerce-shipping-fields__field-wrapper input.input-text');
        $inputs.each(function() {
            $(this).prop('readonly', true).css({
                'background-color': '#f5f5f5',
                'cursor': 'not-allowed'
            });
        });

        // 2. 处理 Select2 (国家/地区, 省/州)
        // Select2 会生成额外的 DOM 结构，需要锁定容器
        var $select2Containers = $('.woocommerce-checkout .woocommerce-shipping-fields__field-wrapper .select2-container');
        $select2Containers.each(function() {
            $(this).css({
                'pointer-events': 'none',
                'opacity': '0.8'
            });
            // 尝试禁用键盘交互
            $(this).find('.select2-selection').attr('tabindex', '-1');
        });
        
        // 同时锁定原始 select 元素 (以防万一)
        $('.woocommerce-checkout .woocommerce-shipping-fields__field-wrapper .select2-selection--single ').each(function() {
            // 注意：不能使用 disabled，否则 WooCommerce 后端验证会报错 "必填字段缺失"
            // 我们依靠 pointer-events: none 和 tabindex="-1" 来防止交互
            $(this).css({
                'background-color': '#f5f5f5',
                'opacity': '0.8'
            }).attr('tabindex', '-1');
            
            // 如果是原生 select (非 Select2)，还需要阻止键盘操作
            $(this).on('mousedown keydown', function(e) {
                e.preventDefault();
                return false;
            });
        });

        // 3. 处理单选框 (Address Type) 和复选框
        // 需要锁定包含 label 的容器，因为点击 label 也会触发改变
        var $radios = $('.woocommerce-checkout .woocommerce-shipping-fields__field-wrapper input[type="radio"], .woocommerce-checkout .woocommerce-shipping-fields__field-wrapper input[type="checkbox"]');
        $radios.each(function() {
            var $this = $(this);
            // 不能 disable，否则无法提交
            // $this.prop('disabled', true); 
            
            // 锁定所在的 form-row 或者 label
            var $row = $this.closest('.form-row');
            $row.css({
                'pointer-events': 'none',
                'cursor': 'not-allowed',
                'opacity': '0.8'
            });
            
            // 额外防止直接点击 input
            $this.css('pointer-events', 'none');
        });
    }

    // 页面加载时执行
    forceShipToDifferent();
    lockShippingFields();

    // 监听 WooCommerce checkout update 事件（AJAX 更新后）
    $(document.body).on('updated_checkout', function() {
        forceShipToDifferent();
        lockShippingFields();
    });
});
