<?php
/**
 * Tooto File Download Widget
 */

namespace Tooto_Elementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;

class File_Download extends Widget_Base {
	public function get_name(): string {
		return 'tooto-file-download';
	}

	public function get_title(): string {
		return __( 'Tooto 文件下载', 'tooto-elementor' );
	}

	public function get_icon(): string {
		return 'eicon-download-button';
	}

	public function get_categories(): array {
		return [ 'tooto' ];
	}

	public function get_keywords(): array {
		return [ 'file', 'download', 'form', 'email', '下载' ];
	}

	public function get_style_depends(): array {
		return [ 'tooto-elementor' ];
	}

	public function get_script_depends(): array {
		return [ 'tooto-elementor' ];
	}

	protected function register_controls(): void {
		// Content Section
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( '内容', 'tooto-elementor' ),
			]
		);

		$this->add_control(
			'file_url',
			[
				'label' => __( '选择文件', 'tooto-elementor' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
					'categories' => [
						\Elementor\Modules\DynamicTags\Module::MEDIA_CATEGORY,
						\Elementor\Modules\DynamicTags\Module::URL_CATEGORY,
						\Elementor\Modules\DynamicTags\Module::IMAGE_CATEGORY,
					],
				],
				'default' => [
					'url' => '',
				],
			]
		);

		$this->add_control(
			'input_placeholder',
			[
				'label' => __( '输入框占位符', 'tooto-elementor' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Enter your email', 'tooto-elementor' ),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __( '按钮文本', 'tooto-elementor' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Download', 'tooto-elementor' ),
			]
		);
		
		$this->add_control(
			'error_message',
			[
				'label' => __( '错误提示', 'tooto-elementor' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Please enter a valid email address.', 'tooto-elementor' ),
			]
		);

		$this->end_controls_section();

		// Style Section - Input
		$this->start_controls_section(
			'section_style_input',
			[
				'label' => __( '输入框样式', 'tooto-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'input_typography',
				'selector' => '{{WRAPPER}} .tooto-file-download__input',
			]
		);

		$this->add_control(
			'input_text_color',
			[
				'label' => __( '文本颜色', 'tooto-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__input' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_bg_color',
			[
				'label' => __( '背景颜色', 'tooto-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__input' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'input_border',
				'selector' => '{{WRAPPER}} .tooto-file-download__input',
			]
		);

		$this->add_control(
			'input_border_radius',
			[
				'label' => __( '圆角', 'tooto-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'input_padding',
			[
				'label' => __( '内边距', 'tooto-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'input_margin_bottom',
			[
				'label' => __( '底部间距', 'tooto-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__input' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Style Section - Button
		$this->start_controls_section(
			'section_style_button',
			[
				'label' => __( '按钮样式', 'tooto-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .tooto-file-download__button',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( '正常', 'tooto-elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( '文本颜色', 'tooto-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_background',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .tooto-file-download__button',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
					'color' => [
						'default' => '#c2272d', // Default red color from screenshot
					],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( '悬停', 'tooto-elementor' ),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => __( '文本颜色', 'tooto-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_background_hover',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .tooto-file-download__button:hover',
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __( '边框颜色', 'tooto-elementor' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'button_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .tooto-file-download__button',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label' => __( '圆角', 'tooto-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' => __( '内边距', 'tooto-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .tooto-file-download__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .tooto-file-download__button',
			]
		);

		$this->end_controls_section();
	}

	protected function render(): void {
		$settings = $this->get_settings_for_display();

		$file_url = $settings['file_url'];
		if ( is_array( $file_url ) && isset( $file_url['url'] ) ) {
			$file_url = $file_url['url'];
		}

		$button_text = $settings['button_text'];
		$input_placeholder = $settings['input_placeholder'];
		$error_message = $settings['error_message'];

		$this->add_render_attribute( 'wrapper', 'class', 'tooto-file-download' );
		$this->add_render_attribute( 'wrapper', 'data-file-url', $file_url );
		$this->add_render_attribute( 'wrapper', 'data-error-message', $error_message );

		?>
		<div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
			<div class="tooto-file-download__input-wrapper">
				<input type="email" class="tooto-file-download__input" placeholder="<?php echo esc_attr( $input_placeholder ); ?>" required>
				<div class="tooto-file-download__error-message"></div>
			</div>
			<button type="button" class="tooto-file-download__button">
				<?php echo esc_html( $button_text ); ?>
			</button>
		</div>
		<?php
	}
}
