<?php
/**
 * Tooto Timeline 组件：垂直时间线展示
 */

namespace Tooto_Elementor\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Repeater;

class Timeline extends Widget_Base {
	public function get_name(): string {
		return 'tooto-timeline';
	}

	public function get_title(): string {
		return __( 'Tooto 时间线', 'tooto-elementor' );
	}

	public function get_icon(): string {
		return 'eicon-time-line';
	}

	public function get_categories(): array {
		return [ 'tooto' ];
	}

	public function get_keywords(): array {
		return [ 'timeline', '时间线', '步骤', '流程', 'tooto' ];
	}

	public function get_style_depends(): array {
		return [ 'tooto-elementor' ];
	}

	protected function register_controls(): void {
		// 内容部分
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( '时间线步骤', 'tooto-elementor' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'step_number',
			[
				'label'       => __( '步骤编号', 'tooto-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'STEP 1', 'tooto-elementor' ),
				'placeholder' => __( 'STEP 1', 'tooto-elementor' ),
			]
		);

		$repeater->add_control(
			'step_title',
			[
				'label'       => __( '标题', 'tooto-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( '步骤标题', 'tooto-elementor' ),
				'placeholder' => __( '输入步骤标题', 'tooto-elementor' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'step_description',
			[
				'label'       => __( '描述', 'tooto-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( '步骤描述内容', 'tooto-elementor' ),
				'placeholder' => __( '输入步骤描述', 'tooto-elementor' ),
				'rows'        => 3,
			]
		);

		$this->add_control(
			'timeline_items',
			[
				'label'       => __( '时间线步骤', 'tooto-elementor' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'step_number'    => 'STEP 1',
						'step_title'     => __( 'Initial Consultation & Case Evaluation', 'tooto-elementor' ),
						'step_description' => __( 'We assess your background, goals, and eligibility.', 'tooto-elementor' ),
					],
					[
						'step_number'    => 'STEP 2',
						'step_title'     => __( 'Strategy Development & Legal Planning', 'tooto-elementor' ),
						'step_description' => __( 'We develop a tailored immigration strategy for your case.', 'tooto-elementor' ),
					],
					[
						'step_number'    => 'STEP 3',
						'step_title'     => __( 'Documentation & Case Preparation', 'tooto-elementor' ),
						'step_description' => __( 'We prepare all filings and supporting documentation.', 'tooto-elementor' ),
					],
					[
						'step_number'    => 'STEP 4',
						'step_title'     => __( 'Filing, Monitoring & Agency Communication', 'tooto-elementor' ),
						'step_description' => __( 'We submit your case and manage agency communications.', 'tooto-elementor' ),
					],
					[
						'step_number'    => 'STEP 5',
						'step_title'     => __( 'Decision Support & Ongoing Guidance', 'tooto-elementor' ),
						'step_description' => __( 'We guide you through approval and future planning.', 'tooto-elementor' ),
					],
				],
				'title_field' => '{{{ step_number }}} - {{{ step_title }}}',
			]
		);

		$this->end_controls_section();

		// 样式部分
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( '样式', 'tooto-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'line_color',
			[
				'label'     => __( '时间线颜色', 'tooto-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#2d5016',
				'selectors' => [
					'{{WRAPPER}} .tooto-timeline__line' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .tooto-timeline__marker' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'marker_hover_color',
			[
				'label'     => __( '悬停标记颜色', 'tooto-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#d4c5a9',
				'selectors' => [
					'{{WRAPPER}} .tooto-timeline__item:hover .tooto-timeline__marker' => 'background-color: {{VALUE}}; box-shadow: 0 0 0 7px {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'step_label_color',
			[
				'label'     => __( '步骤标签颜色', 'tooto-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#6b7280',
				'selectors' => [
					'{{WRAPPER}} .tooto-timeline__step-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'step_label_hover_color',
			[
				'label'     => __( '悬停步骤标签颜色', 'tooto-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#d4c5a9',
				'selectors' => [
					'{{WRAPPER}} .tooto-timeline__item:hover .tooto-timeline__step-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => __( '标题颜色', 'tooto-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#1f2937',
				'selectors' => [
					'{{WRAPPER}} .tooto-timeline__title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => __( '描述颜色', 'tooto-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#1f2937',
				'selectors' => [
					'{{WRAPPER}} .tooto-timeline__description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'item_spacing',
			[
				'label'      => __( '步骤间距', 'tooto-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'size' => 32,
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .tooto-timeline__item:not(:last-child)' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'content_gap',
			[
				'label'      => __( '内容间距', 'tooto-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'default'    => [
					'size' => 8,
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .tooto-timeline__content' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// 步骤标签样式
		$this->start_controls_section(
			'section_step_label_style',
			[
				'label' => __( '步骤标签', 'tooto-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'step_label_typography',
				'label'    => __( '文字排版', 'tooto-elementor' ),
				'selector' => '{{WRAPPER}} .tooto-timeline__step-label',
			]
		);

		$this->end_controls_section();

		// 标题样式
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => __( '标题', 'tooto-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => __( '文字排版', 'tooto-elementor' ),
				'selector' => '{{WRAPPER}} .tooto-timeline__title',
			]
		);

		$this->end_controls_section();

		// 描述样式
		$this->start_controls_section(
			'section_description_style',
			[
				'label' => __( '描述', 'tooto-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'description_typography',
				'label'    => __( '文字排版', 'tooto-elementor' ),
				'selector' => '{{WRAPPER}} .tooto-timeline__description',
			]
		);

		$this->end_controls_section();
	}

	protected function render(): void {
		$settings = $this->get_settings_for_display();

		if ( empty( $settings['timeline_items'] ) ) {
			return;
		}

		?>
		<div class="tooto-timeline">
			<div class="tooto-timeline__line"></div>
			<div class="tooto-timeline__items">
				<?php foreach ( $settings['timeline_items'] as $index => $item ) : ?>
					<div class="tooto-timeline__item">
						<div class="tooto-timeline__marker"></div>
						<div class="tooto-timeline__content">
							<?php if ( ! empty( $item['step_number'] ) ) : ?>
								<div class="tooto-timeline__step-label"><?php echo esc_html( $item['step_number'] ); ?></div>
							<?php endif; ?>
							<?php if ( ! empty( $item['step_title'] ) ) : ?>
								<h3 class="tooto-timeline__title"><?php echo esc_html( $item['step_title'] ); ?></h3>
							<?php endif; ?>
							<?php if ( ! empty( $item['step_description'] ) ) : ?>
								<p class="tooto-timeline__description"><?php echo esc_html( $item['step_description'] ); ?></p>
							<?php endif; ?>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<?php
	}
}

