<?php
/**
 * Plugin Name: Tooto Elementor Addons
 * Description: 自定义 Elementor 组件拓展。支持自定义 WooCommerce My Account 页面。
 * Version: 0.1.58
 * Author: Tooto
 * Text Domain: tooto-elementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'TOOTO_EA_VERSION', '0.1.58' );
define( 'TOOTO_EA_FILE', __FILE__ );
define( 'TOOTO_EA_PATH', plugin_dir_path( __FILE__ ) );
define( 'TOOTO_EA_URL', plugin_dir_url( __FILE__ ) );

require_once TOOTO_EA_PATH . 'includes/class-tooto-elementor-plugin.php';

add_action(
	'plugins_loaded',
	static function () {
		\Tooto_Elementor\Plugin::instance();
	}
);

// 插件激活时刷新重写规则
register_activation_hook( TOOTO_EA_FILE, function() {
	// 确保 WooCommerce 端点已注册
	if ( class_exists( 'WooCommerce' ) ) {
		\WC()->query->init_query_vars();
		\WC()->query->add_endpoints();
	}
	\flush_rewrite_rules();
} );

// 插件停用时刷新重写规则
register_deactivation_hook( TOOTO_EA_FILE, function() {
	\flush_rewrite_rules();
} );

